// CSPORTALL.3DN.RU

#include < amxmodx >
#include < cstrike >
#include < fakemeta >
#include < hamsandwich >

#define VERSION 		"2.0"
#define HEALTH_BAR_MODEL	"sprites/health.spr"
#define is_player(%1)		( 1 <= %1 <= g_maxPlayers )
#define is_alive(%1)		( g_playerStatus[ %1 ] == ALIVE )
#define same_team(%1,%2)	( g_playerTeam[ %1 ] == g_playerTeam[ %2 ] )

enum _: g_enum_playerStatus
{
	DISCONNECTED = 0,
	DEAD,
	ALIVE
}

const ENTITIES_USER = 85768484848

new g_playerBar[ 33 ], g_playerStatus[ 33 ], CsTeams: g_playerTeam[ 33 ], g_playerBot[ 33 ], g_playerMaxHealth[ 33 ], g_showHB[ 33 ]
new pcvarBotSupport, pcvarShowMode, pcvarSpec, cvarSpec, cvarShowMode, cvarBotSupport
new g_maxPlayers, fwShowMode, botRegistered, msg_SayText

public plugin_init( ) 
{
	register_plugin( "Health Bar", VERSION, "Bboy Grun" )
	
	register_cvar( "Health_Bars", VERSION, FCVAR_SERVER | FCVAR_SPONLY )
	set_cvar_string( "Health_Bars", VERSION )
	
	RegisterHam( Ham_Spawn, "player", "fwHamSpawn", 1 )
	
	register_event( "HLTV", "evRoundStart", "a", "1=0", "2=0" )
	register_event( "DeathMsg", "evDeathMsg", "a" )
	register_event( "Health", "evHealth", "be" )
	
	register_clcmd( "say hb", "hbHandle" )
	register_clcmd( "say /hb", "hbHandle" )
	
	pcvarShowMode = 		register_cvar( "health_ShowMode", "1" )
	pcvarBotSupport = 		register_cvar( "health_BotSupport", "1" )
	pcvarSpec = 			register_cvar( "health_ShowToSpectators", "1" )
	
	g_maxPlayers = get_maxplayers( )
	msg_SayText = get_user_msgid( "SayText" )
	
	createHealthHuds( )
	evRoundStart( )
}

public hbHandle( id )
{
	if( g_showHB[ id ] )
	{
		g_showHB[ id ] = false
		
		message_begin( MSG_ONE_UNRELIABLE, msg_SayText, .player = id )
		write_byte( id )
		write_string( "^x04[ HEALTH BARS ]^x03 Disabled for you^x01 ! Write /hb to^x04 enable^x01 it" )
		message_end( )
	}
	else
	{
		g_showHB[ id ] = true
		
		message_begin( MSG_ONE_UNRELIABLE, msg_SayText, .player = id )
		write_byte( id )
		write_string( "^x04[ HEALTH BARS ]^x03 Enabled for you^x01 ! Write /hb to^x04 disable^x01 it" )
		message_end( )
	}
}

public plugin_init_bots( id )
{
	RegisterHamFromEntity( Ham_Spawn, id, "fwHamSpawn", 1 )
	
	fwHamSpawn( id )
}

public plugin_precache( )
{
	precache_model( HEALTH_BAR_MODEL )
}

public client_putinserver( id )
{
	g_playerStatus[ id ] = DEAD
	g_playerTeam[ id ] = CS_TEAM_SPECTATOR
	g_playerBot[ id ] = is_user_bot( id )
	g_playerMaxHealth[ id ] = 0
	g_showHB[ id ] = true
	
	if( cvarBotSupport && !botRegistered && g_playerBot[ id ] && get_cvar_num( "bot_quota" ) > 0 )
	{
		set_task( 0.4, "plugin_init_bots", id )
		botRegistered = 1
	}
}

public client_disconnect( id )
{
	g_playerStatus[ id ] = DISCONNECTED
	g_playerTeam[ id ] = CS_TEAM_UNASSIGNED
	g_playerBot[ id ] = 0
	g_playerMaxHealth[ id ] = 0
	g_showHB[ id ] = false
	
	engfunc( EngFunc_SetOrigin, g_playerBar[ id ], Float: { -9999.0, -9999.0, -9999.0 } )
}

public fwAddToFullPack( es, e, ent, host, host_flags, player, p_set )
{
	if( is_player( host ) && g_showHB[ host ] && !is_player( ent ) && !g_playerBot[ host ] )
	{
		if( ( is_alive( host ) && !cvarSpec ) || cvarSpec )
		{
			if( pev_valid( ent ) && pev( ent, pev_iuser1 ) == ENTITIES_USER )
			{
				new user = pev( ent, pev_iuser2 )
	
				if( user != host && is_alive( user ) )
				{
					if( ( !cvarBotSupport && !g_playerBot[ user ] ) || cvarBotSupport )
					{
						if( cvarShowMode == 2 || ( cvarShowMode == 1 && same_team( host, user ) ) )
						{
							new Float: playerOrigin[ 3 ]
							pev( user, pev_origin, playerOrigin )
							
							playerOrigin[ 2 ] += 30.0 
							
							engfunc( EngFunc_SetOrigin, ent, playerOrigin )
							set_es( es, ES_RenderMode, kRenderNormal )
							set_es( es, ES_RenderAmt, 220 )
						}
					}
				}
			}
		}
	}
}

public fwHamSpawn( id )
{
	if( is_user_alive( id ) )
	{
		g_playerStatus[ id ] = ALIVE
		g_playerTeam[ id ] = cs_get_user_team( id )
		
		checkHealth( id )
	}
}

public evDeathMsg( )
{
	new id = read_data( 2 )
	
	g_playerStatus[ id ] = DEAD
	g_playerTeam[ id ] = cs_get_user_team( id )
	g_playerMaxHealth[ id ] = 0
	
	engfunc( EngFunc_SetOrigin, g_playerBar[ id ], Float: { -9999.0, -9999.0, -9999.0 } )
}

public evHealth( id )
{
	checkHealth( id )
}

public evRoundStart( )
{
	cvarShowMode = 		get_pcvar_num( pcvarShowMode )
	cvarSpec = 		get_pcvar_num( pcvarSpec )
	new valueBotSupport = 	get_pcvar_num( pcvarBotSupport )
	
	for( new id = 1; id <= g_maxPlayers; id ++ )
	{
		engfunc( EngFunc_SetOrigin, g_playerBar[ id ], Float: { -9999.0, -9999.0, -9999.0 } )
	}
	
	if( cvarShowMode > 0 )
	{
		if( !fwShowMode )
		{
			fwShowMode = register_forward( FM_AddToFullPack, "fwAddToFullPack", 1 )
		}
	}
	else
	{
		if( fwShowMode )
		{
			unregister_forward( FM_AddToFullPack, fwShowMode, 1 )
			fwShowMode = 0
		}
	}
	
	if( valueBotSupport && !botRegistered )
	{	
		for( new id = 1; id <= g_maxPlayers; id ++ )
		{
			if( g_playerBot[ id ] )
			{
				plugin_init_bots( id )
				botRegistered = 1
				break;
			}
		}
	}
	
	cvarBotSupport = valueBotSupport
}

stock checkHealth( id )
{
	new hp = get_user_health( id )
	
	if( g_playerMaxHealth[ id ] < hp )
	{
		g_playerMaxHealth[ id ] = hp
		ent_setFrame( id, 0 )
	}
	else
	{
		ent_setFrame( id, 1, hp )
	}
}

stock ent_setFrame( id, check = 1, health = 0 )
{
	set_pev( g_playerBar[ id ], pev_frame, check == 0 ? ( 99.0 ) : ( 0.0 + ( ( ( health - 1 ) * 100 ) / g_playerMaxHealth[ id ] ) ) )
}

createHealthHuds( )
{
	new allocString = engfunc( EngFunc_AllocString, "env_sprite" )
	
	for( new id = 1; id <= g_maxPlayers; id ++ )
	{
		g_playerBar[ id ] = engfunc( EngFunc_CreateNamedEntity, allocString )
		
		if( pev_valid( g_playerBar[ id ] ) )
		{
			set_pev( g_playerBar[ id ], pev_solid, SOLID_NOT )
			set_pev( g_playerBar[ id ], pev_iuser2, id )
			set_pev( g_playerBar[ id ], pev_iuser1, ENTITIES_USER )
			set_pev( g_playerBar[ id ], pev_scale, 0.1 )
			engfunc( EngFunc_SetModel, g_playerBar[ id ], HEALTH_BAR_MODEL )
			set_pev( g_playerBar[ id ], pev_renderfx, kRenderTransAlpha )
			set_pev( g_playerBar[ id ], pev_renderamt, 0.0 )
		}
	}
}
